/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Collections;
using Borland.Eco.UmlRt;
using Borland.Eco.ObjectRepresentation;

namespace Borland.Eco.ObjectImplementation
{
	public interface IContent 
	{
		System.Object get_MemberByIndex(int index);
		void set_MemberByIndex(int index, System.Object value);
		IObjectInstance AsIObject();
		void AssertLoopbackUnassigned();
		void LoopbackValid();
	}

	public interface ILoopBack: IObjectProvider
	{
		System.Object get_MemberByIndex(int index);
		void set_MemberByIndex(int index, System.Object value);
	}

	public interface  IInternalObjectContentFactory
	{
		IContent CreateContent(System.Object dotNetObject);
		void CreateContentFailed(IContent obj, System.Object dotNetObject);
	}

	public class ObjectListAdapter: System.Object, IList
	{
		private readonly IList fAdaptee;

		protected IList Adaptee
		{
			get { return fAdaptee; }
		}

		public ObjectListAdapter(IList list)
		{
			fAdaptee = list;
		}

		public void Clear()
		{
			Adaptee.Clear();
		}

		void IList.Clear()
		{
			Adaptee.Clear();
		}		
		
		public IEnumerator GetEnumerator()
		{
			return Adaptee.GetEnumerator();
		}

		IEnumerator IEnumerable.GetEnumerator()
		{
			return Adaptee.GetEnumerator();
		}

		
		bool IList.Contains(System.Object value)
		{
			return Adaptee.Contains(value);
		}
		
		int IList.IndexOf(System.Object value)
		{
			return Adaptee.IndexOf(value);
		}
		
		void IList.Insert(int index, System.Object value)
		{
			Adaptee.Insert(index, value);
		}
		
		void IList.Remove(System.Object value)
		{
			Adaptee.Remove(value);
		}
		
		public void CopyTo(System.Array array, int index)
		{
			Adaptee.CopyTo(array, index);
		}
		
		public System.Object SyncRoot
		{
			get { return Adaptee.SyncRoot; }
		}
		
		public bool IsSynchronized
		{
			get { return Adaptee.IsSynchronized; }
		}
		
		public void RemoveAt(int index)
		{
			Adaptee.RemoveAt(index);
		}

		void IList.RemoveAt(int index)
		{
			Adaptee.RemoveAt(index);
		}

		System.Object IList.this[int index]
		{
			get { return Adaptee[index]; }
			set { Adaptee[index] = value; }
		}
		
		bool IList.IsReadOnly
		{
			get { return Adaptee.IsReadOnly; }
		}

		int IList.Add(System.Object  value)
		{
			return Adaptee.Add(value);
		}

		int ICollection.Count
		{
			get { return Adaptee.Count; }
		}
		
		public int Count
		{
			get { return Adaptee.Count; }
		}
		
		bool IList.IsFixedSize
		{
			get { return Adaptee.IsFixedSize; }
		}
	}
}
